#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
using namespace std;

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	int n; cin >> n;
	vector<pair<int, double>> freelancers(n);
	for (int i = 0; i < n; i++)
	{
		int salary; cin >> salary;
		double tax; cin >> tax;
		freelancers[i].first = salary;
		freelancers[i].second = tax;
	}
	sort(freelancers.begin(), freelancers.end(), [](pair<int, double> f1, pair<int, double> f2) { return f1.second > f2.second; });

	long long prefix_salary = 0;
	double max_tax_revenue = -1;
	for (int i = 0; i < n; i++)
	{
		prefix_salary += freelancers[i].first;
		double tax = freelancers[i].second;
		double current_tax_revenue = (double)prefix_salary * 0.01 * tax;
		max_tax_revenue = max(max_tax_revenue, current_tax_revenue);
	}

	cout << fixed;
	cout << max_tax_revenue << endl;
}